
(* 1 flyway 1 xbot (actual physical) - autoloading delete,create,activate,holdforzoneready,loadingzoneclear  *)
FUNCTION_BLOCK Example24b_autoloading_receiving
	(*delete any existing zones*)
	PMC_AutoLoadingZone_Delete1(PM_Controller := PM_Controller,PM_Controller := PM_Controller,Execute := Execute,ZoneID := 0);

	(*create an autoloading loading zone on the top left edge (75,240) of the flyway*)
	PMC_AutoLoadingZone_Create1(PM_Controller := PM_Controller,PM_Controller := PM_Controller,Execute := PMC_AutoLoadingZone_Delete1.Done,ZoneID := 1,ZoneMode := 1,UnloadingMode := 0,ZoneCenterX := 0.075,ZoneCenterY := 0.24,ZoneLength := 0.12,ZoneWidth := 0.15,MaxXbotSizeX := 0.12,MaxXbotSizeY := 0.12,MaxVel := 2,MaxAcc := 10,MaxHeight := 0);

	(*activate the loading zone*)
	PMC_AutoLoadingZone_Activate1(PM_Controller := PM_Controller,PM_Controller := PM_Controller,Execute := PMC_AutoLoadingZone_Create1.Done,ZoneID := 1);

	(*hold until the zone is ready (xbot is in the zone and is ready to move out of the zone*)
	PMC_AutoLoadingZon_HolZoneReady1(PM_Controller := PM_Controller,PM_Controller := PM_Controller,Execute := PMC_AutoLoadingZone_Activate1.Done,ZoneID := 1);

	(*move xbot out of the zone*)
	PMC_XYMotion1(PM_Controller := PM_Controller,Execute := PMC_AutoLoadingZon_HolZoneReady1.Done,cmdLB := 1,XbotID := PMC_AutoLoadingZon_HolZoneReady1.xbotID,Mode := 0,Type_ := 1,PosX := 0.18,PosY := 0.06,EndVel := 0,MaxVel := 1,MaxAcc := 10);

	(*tell the loading zone that the xbot has moved clear *)
	PMC_AutoLoadZone_LoadZoneClear1(PM_Controller := PM_Controller,PM_Controller := PM_Controller,Execute := PMC_XYMotion1.Done,ZoneID := 1);

	Done := PMC_AutoLoadZone_LoadZoneClear1.Done;
END_FUNCTION_BLOCK
